/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_backpacks.screen;

import info.u_team.u_team_core.gui.elements.ScrollableList;
import info.u_team.u_team_core.util.RegistryUtil;
import info.u_team.u_team_core.util.ResourceLocationUtil;
import info.u_team.useful_backpacks.menu.TagFilterMenu;
import info.u_team.useful_backpacks.screen.TagFilterTagListEntry;
import io.netty.buffer.Unpooled;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public class TagFilterTagList
extends ScrollableList<TagFilterTagListEntry> {
    private final TagFilterMenu menu;

    public TagFilterTagList(TagFilterMenu menu, int x, int y, int width, int height, String tag) {
        super(x, y, width, height, 10, 15);
        this.menu = menu;
        this.m_93496_(false);
        this.setRenderTransparentBorder(true);
        this.updateEntries(unused -> true);
        if (!tag.isEmpty()) {
            this.m_6702_().stream().filter(entry -> entry.getTag().toString().equals(tag)).findAny().ifPresent(entry -> {
                super.m_6987_((AbstractSelectionList.Entry)entry);
                this.m_93494_((AbstractSelectionList.Entry)entry);
            });
        }
    }

    public void setSelected(TagFilterTagListEntry entry) {
        super.m_6987_((AbstractSelectionList.Entry)entry);
        String tag = entry.getTag().toString();
        this.menu.getTagMessage().triggerMessage(() -> new FriendlyByteBuf(Unpooled.buffer((int)100)).m_130070_(tag));
        this.menu.setTag(tag);
    }

    public void updateSearch(String search) {
        if (search.isEmpty()) {
            this.updateEntries(tag -> true);
        } else {
            this.updateEntries(tag -> tag.m_135827_().startsWith(search) || tag.m_135815_().startsWith(search));
        }
    }

    private void updateEntries(Predicate<ResourceLocation> predicate) {
        List<ResourceLocation> list = RegistryUtil.getBuiltInRegistry((ResourceKey)Registries.f_256913_).m_255303_().m_255107_().filter(tagKey -> predicate.test(tagKey.f_203868_())).map(TagKey::f_203868_).collect(Collectors.toList());
        Collections.sort(list, ResourceLocationUtil.nameSpacedComparator());
        TagFilterTagListEntry selected = (TagFilterTagListEntry)this.m_93511_();
        this.m_93516_();
        this.m_93410_(0.0);
        list.forEach(tag -> {
            TagFilterTagListEntry entry = new TagFilterTagListEntry((ResourceLocation)tag);
            this.m_7085_((AbstractSelectionList.Entry)entry);
            if (selected != null && selected.getTag().equals(tag)) {
                super.m_6987_((AbstractSelectionList.Entry)entry);
            }
        });
        if (this.m_93511_() != null) {
            this.m_93494_((AbstractSelectionList.Entry)((TagFilterTagListEntry)this.m_93511_()));
        }
    }
}

